<html>
<head>
    <title> {{__('Powertransz Payment Gateway')}}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&family=Rethink+Sans&display=swap" rel="stylesheet">
    <style>
        *{
            margin: 0;
            padding: 0;
            font-family: 'Poppins', sans-serif;
            font-family: 'Rethink Sans', sans-serif;
        }
        .autorize-payment-wrapper{
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100%;
        }
        .autorize-payment-inner-wrapper {
            max-width: 600px;
            box-shadow: 0 0 40px 0 rgba(0,0,0,0.05);
            border-radius: 10px;
            padding: 30px 40px 30px;
        }

        .autorize-payment-inner-wrapper .logo-wrapper img {
            max-width: 200px;
            margin: 0 auto;
        }

        .autorize-payment-inner-wrapper .logo-wrapper {
            text-align: center;
            margin-bottom: 40px;
        }
        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            font-size: 16px;
            line-height: 20px;
            margin-bottom: 5px;
        }

        div#cc-form {
            margin-top: 30px;
        }

        .form-group input {
            height: 30px;
            border: 1px solid #f2f2f2;
            border-radius: 5px;
            padding: 5px 10px;
            display: block;
            width: 100%;
        }
        .cardinfo_wrap {
            display: flex;
            justify-content: space-between;
        }
        .btn-wrapper {
            display: block;
            text-align: center;
        }

        .btn-wrapper button {
            border: none;
            padding: 15px 25px;
            display: inline-block;
            border-radius: 5px;
            margin-top: 30px;
            background-color: #333;
            color: #fff;
            transition: all 300ms;
            cursor: pointer;
        }
        .btn-wrapper button:hover{
            opacity: .8;
        }
    </style>
</head>
<body>
<div class="autorize-payment-wrapper">
    <div class="autorize-payment-inner-wrapper">
        <div class="logo-wrapper">
            <img src="data:image/png;base64,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" alt="">
        </div>
        <div class='card-wrapper'></div>
        <form id="stripe_form" method="post" action="{{route('xg.payment.gateway.powertransz')}}">
            @csrf
{{--            @dd($powertransz_data)--}}
            @foreach($powertransz_data as $field_name => $value)
                <input type="hidden" name="{{$field_name}}"  value="{{$value}}"/>
            @endforeach
                <div id="cc-form">
                    <div class="form-group">
                        <label>{{__('Card Number')}}</label>
                        <input type="text" name="number" placeholder="{{__("card number")}}">
                    </div>
                    <div class="form-group">
                        <label>{{__('Full Name')}}</label>
                        <input type="text" name="name" placeholder="{{__("full name")}}"/>
                    </div>
                    <div class="cardinfo_wrap">
                        <div class="form-group">
                            <label>{{__('Expiry')}}</label>
                            <input type="text" name="expiry" placeholder="{{__("expiry")}}"/>
                        </div>
                        <div class="form-group">
                            <label>{{__('CVC')}}</label>
                            <input type="text" name="cvc" placeholder="{{__("cvc")}}"/>
                        </div>
                    </div>
                </div>
            <div class="btn-wrapper">
                <button type="submit">{{__('Pay')}} {{$powertransz_data['charge_amount'].''.$powertransz_data['currency']}}</button>
            </div>
        </form>

    </div>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/card/2.5.4/card.js" integrity="sha512-lIdTIGaSjFWSxmWDSyKbLz1OJ3c1o4Vm6FXRguKH1HzOVCRSF8Ypg30+yga7j5TUMh4Sf5iFvC9/NQQr1KumQg==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>

<script>
    var card = new Card({
        form: '#cc-form',
        container: '.card-wrapper',

        formSelectors: {
            nameInput: 'input[name="name"]'
        }
    });
</script>
</body>
</html>
